/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY                          *
 *                                                                            *
 * This program is free software; you can redistribute it and/or modify       *
 * it under the terms of the GNU General Public Liense as published by        *
 * the Free Software Foundation, either version 2 of the License, or (at      * 
 * your option) any later version.                                            *
 *                                                                            *
 * The ITX package is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY, without even the implied warranty of MERCHANTABILITY *
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License   *
 * for more details.                                                          * 
 *                                                                            *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.                                                   *
 *                                                                            * 
 * Contact information:                                                       *
 * Donna Bergmark                                                             *
 * 484 Rhodes Hall                                                            *
 * Cornell University                                                         *
 * Ithaca, NY 14853-3801                                                      *
 * bergmark@cs.cornell.edu                                                    *
 ******************************************************************************/
package cnrg.itx.datax.client;

import java.io.*;
import cnrg.itx.datax.*;
import cnrg.itx.datax.devices.*;
import java.util.*;

/**
 * Class to excersize the mixer code.
 * Run with n arguments: pcm files to mix.
 */
class SpeakerMix implements Observer
{
	public static final int BUFFER_TIME = 100;
	
	public static void main(String [] args) throws Exception
	{


		MixerChannel mc = new MixerChannel();
		Channel ic;
		
		for (int i = 0;i<args.length;i++){
			FileInputStream fis = new FileInputStream(args[i]);
			ic = mc.getNewInput();
			ic.setSource(new StreamSource(fis,ic,BUFFER_TIME));
		}
		
		ic = mc.getNewInput();
		ic.setSource(new MicrophoneSource(ic));
		
		mc.addDestination(new SpeakerDestination() );

		AudioConnection ac = new AudioConnection (mc, null);
		ac.addObserver(new SpeakerMix() );
		ac.open();
		System.in.read();	
		ac.close();
		System.exit(1);
	}

	public void update(Observable o, Object arg) 
	{
		System.out.println(arg);
	}
}

